
set more off
quiet: do "INDIVIDUAL 3. Merge TWM and RILA.do"

*************************************************************************
***** Mixed Effects Ordinal Logistic Regression
*************************************************************************
log using "Table 3. Regression of Religious Bonding.log", replace

meologit zbonding1JOINED muslim zfreqprayJOINED zeduJOINED zageJOINED female rural zpersonaleconJOINED favordem onetruefaith ///
						zloggdppcJOINED zrdiJOINED zGRIJOINED zpolity2JOINED || COUNTRY:
gen used_all = e(sample)
estimates store me1

*excluding muslim countries that are more religiously homogeneous than the most homogeneous catholic country
meologit zbonding1JOINED muslim zfreqprayJOINED zeduJOINED zageJOINED female rural zpersonaleconJOINED favordem onetruefaith ///
						zloggdppcJOINED zrdiJOINED zGRIJOINED zpolity2JOINED if !(muslim == 1 & rdi2010 < .7) || COUNTRY:
gen used_restricted = e(sample)
estimates store me2

esttab me* using "Table 3. Regression of Religious Bonding.csv", b(3) se(2) starlevels(+ .10 * .05 ** .01 *** .001) r2(3) nogaps replace

tab icountry if used_all == 1 
tab icountry if used_all==1 & used_restricted==0
log close


*******************************************************************************************************
***** Effect Size
*******************************************************************************************************

set more off
log using "Table S9. Effects Sizes in the Higher Bonding Regressions.log", replace

meologit zbonding1JOINED muslim zfreqprayJOINED zeduJOINED zageJOINED female rural zpersonaleconJOINED favordem onetruefaith ///
						zloggdppcJOINED zrdiJOINED zGRIJOINED zpolity2JOINED || COUNTRY:, or
estimates store effsize1


*excluding muslim countries that are more religiously homogeneous than the most homogeneous catholic country
meologit zbonding1JOINED muslim zfreqprayJOINED zeduJOINED zageJOINED female rural zpersonaleconJOINED favordem onetruefaith ///
						zloggdppcJOINED zrdiJOINED zGRIJOINED zpolity2JOINED if !(muslim == 1 & rdi2010 < .7) || COUNTRY:, or
estimates store effsize2

esttab effsize* using "Table S9. Effects Sizes in the Higher Bonding Regressions.csv", b(3) se(2) starlevels(+ .10 * .05 ** .01 *** .001) r2(3) nogaps replace eform

log close


